"use strict";
(() => {
  // src/content/banana.ts
  var currentPromptId = null;
  var observer = null;
  var FLOW = {
    promptTextarea: [
      "#PINHOLE_TEXT_AREA_ELEMENT_ID",
      'textarea[placeholder*="\u0421\u0433\u0435\u043D\u0435\u0440\u0438\u0440\u0443\u0439\u0442\u0435"]',
      'textarea[placeholder*="\u0442\u0435\u043A\u0441\u0442\u043E\u0432\u043E\u043C\u0443 \u0437\u0430\u043F\u0440\u043E\u0441\u0443"]',
      'textarea[placeholder*="\u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435"]',
      'textarea[placeholder*="Generate"]',
      'textarea[placeholder*="text prompt"]',
      'textarea[placeholder*="prompt"]',
      "textarea"
    ],
    createButton: [
      "button.gdArnN.gdXWm",
      "button.sc-408537d4-2.gdXWm"
    ],
    createButtonByText: ["\u0421\u043E\u0437\u0434\u0430\u0442\u044C", "Create"],
    // Image generation mode texts
    imageModeTexts: ["\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435", "Create image", "Generate image"],
    modeDropdownSelectors: ["button.sc-bd77098e-1", "button.hdOBaY", "button.hKBFUo"]
  };
  chrome.runtime.onMessage.addListener((message, _sender, sendResponse) => {
    if (message.type === "PING") {
      sendResponse({ pong: true });
      return false;
    }
    if (message.type === "INJECT_PROMPT") {
      const payload = message.payload;
      if (payload.settings?.service !== "banana")
        return false;
      injectPrompt(payload);
      sendResponse({ success: true });
      return false;
    }
    return false;
  });
  function isFlowHost() {
    return /labs\.google(\.com)?\/fx/i.test(window.location.href);
  }
  function waitForElement(selector, timeout) {
    return new Promise((resolve, reject) => {
      const el = document.querySelector(selector);
      if (el) {
        resolve(el);
        return;
      }
      const obs = new MutationObserver(() => {
        const el2 = document.querySelector(selector);
        if (el2) {
          obs.disconnect();
          resolve(el2);
        }
      });
      obs.observe(document.body, { childList: true, subtree: true });
      setTimeout(() => {
        obs.disconnect();
        reject(new Error(`Timeout waiting for ${selector}`));
      }, timeout);
    });
  }
  function sleep(ms) {
    return new Promise((r) => setTimeout(r, ms));
  }
  function findFlowPromptInput() {
    for (const sel of FLOW.promptTextarea) {
      const el = document.querySelector(sel);
      if (el && el instanceof HTMLTextAreaElement && el.offsetParent !== null) {
        return el;
      }
    }
    return null;
  }
  function findFlowCreateButton() {
    for (const sel of FLOW.createButton) {
      const el = document.querySelector(sel);
      if (el && el instanceof HTMLElement && !el.disabled) {
        return el;
      }
    }
    const buttons = document.querySelectorAll("button");
    for (const btn2 of buttons) {
      const text = (btn2.textContent || "").trim();
      if (FLOW.createButtonByText.some((t) => text.includes(t)) && !btn2.disabled) {
        return btn2;
      }
    }
    const overlay = document.querySelector('button.gdArnN.gdXWm div[data-type="button-overlay"]');
    const btn = overlay?.closest("button");
    return btn && !btn.disabled ? btn : null;
  }
  function isVisible(el) {
    const style = window.getComputedStyle(el);
    return style.display !== "none" && style.visibility !== "hidden" && style.opacity !== "0" && el.offsetWidth > 0 && el.offsetHeight > 0;
  }
  async function selectImageMode() {
    console.log("[GenFlow] Banana: Selecting image generation mode...");
    const TARGET_TEXTS = ["\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435", "\u0441\u043E\u0437\u0434\u0430\u0442\u044C \u0438\u0437\u043E\u0431\u0440\u0430\u0436\u0435\u043D\u0438\u0435", "Create image", "Generate image"];
    let dropdownBtn = null;
    const allButtons = document.querySelectorAll("button");
    for (const btn of allButtons) {
      const text = (btn.textContent || "").trim();
      const hasArrow = btn.querySelector("svg") || text.includes("arrow");
      const hasModeText = text.includes("\u0412\u0438\u0434\u0435\u043E \u043F\u043E") || text.includes("\u0421\u043E\u0437\u0434\u0430\u0442\u044C") || text.includes("Video") || text.includes("Create");
      if (hasArrow && hasModeText && isVisible(btn)) {
        dropdownBtn = btn;
        console.log(`[GenFlow] Banana: Found dropdown button: "${text.substring(0, 30)}"`);
        break;
      }
    }
    if (!dropdownBtn) {
      for (const sel of FLOW.modeDropdownSelectors) {
        const el = document.querySelector(sel);
        if (el && isVisible(el)) {
          dropdownBtn = el;
          break;
        }
      }
    }
    if (!dropdownBtn) {
      console.log("[GenFlow] Banana: Mode dropdown not found");
      return;
    }
    const currentText = (dropdownBtn.textContent || "").toLowerCase();
    if (TARGET_TEXTS.some((t) => currentText.includes(t.toLowerCase()))) {
      console.log("[GenFlow] Banana: Already in image mode");
      return;
    }
    console.log(`[GenFlow] Banana: Current mode "${currentText}", opening dropdown...`);
    dropdownBtn.click();
    await sleep(800);
    console.log("[GenFlow] Banana: Looking for image mode option...");
    const findAndClickImageMode = () => {
      const allElements = document.querySelectorAll("*");
      for (const el of allElements) {
        const text = (el.textContent || "").trim();
        if (TARGET_TEXTS.some((t) => text === t || text.includes(t))) {
          if (isVisible(el) && el.offsetHeight > 0) {
            console.log(`[GenFlow] Banana: Found image mode option: "${text}"`);
            el.click();
            return true;
          }
        }
      }
      const options = document.querySelectorAll('[role="option"], [role="menuitem"], [data-radix-collection-item]');
      for (const opt of options) {
        const text = (opt.textContent || "").trim();
        console.log(`[GenFlow] Banana: Option: "${text}"`);
        if (TARGET_TEXTS.some((t) => text.toLowerCase().includes(t.toLowerCase()))) {
          opt.click();
          return true;
        }
      }
      return false;
    };
    if (findAndClickImageMode()) {
      await sleep(500);
      console.log("[GenFlow] Banana: Image mode selected");
      return;
    }
    document.body.click();
    console.log("[GenFlow] Banana: Failed to find image mode option");
  }
  function closeFlowDialogIfOpen() {
    const dialog = document.querySelector('[role="dialog"], .PopoverContent[data-state="open"]');
    if (!dialog)
      return;
    document.body.dispatchEvent(new KeyboardEvent("keydown", { key: "Escape", keyCode: 27, bubbles: true }));
    document.body.dispatchEvent(new KeyboardEvent("keyup", { key: "Escape", keyCode: 27, bubbles: true }));
  }
  function isOnFlowProjectPage() {
    return /\/project\/[a-f0-9-]+/i.test(window.location.pathname);
  }
  async function ensureFlowProjectPage() {
    if (isOnFlowProjectPage()) {
      console.log("[GenFlow] Banana: Already on project page, reusing...");
      return;
    }
    await sleep(2e3);
    const existingProjects = document.querySelectorAll('[href*="/project/"]');
    if (existingProjects.length > 0) {
      console.log("[GenFlow] Banana: Found existing project, opening...");
      existingProjects[0].click();
      for (let i = 0; i < 30; i++) {
        await sleep(500);
        if (isOnFlowProjectPage())
          break;
      }
      if (isOnFlowProjectPage()) {
        await sleep(2e3);
        return;
      }
    }
    let createProjectBtn = null;
    const createBtnTexts = ["\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u043F\u0440\u043E\u0435\u043A\u0442", "Create project", "\u0422\u0432\u043E\u0440\u0438\u0442\u0435 \u0441 \u043F\u043E\u043C\u043E\u0449\u044C\u044E Flow", "Create with Flow"];
    for (let i = 0; i < 40; i++) {
      createProjectBtn = Array.from(document.querySelectorAll("button")).find(
        (b) => createBtnTexts.some((text) => (b.textContent || "").includes(text))
      );
      if (createProjectBtn)
        break;
      await sleep(500);
    }
    if (!createProjectBtn) {
      throw new Error("\u041A\u043D\u043E\u043F\u043A\u0430 \xAB\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u043F\u0440\u043E\u0435\u043A\u0442\xBB \u043D\u0435 \u043D\u0430\u0439\u0434\u0435\u043D\u0430. \u041E\u0442\u043A\u0440\u043E\u0439\u0442\u0435 Flow \u0438 \u043D\u0430\u0436\u043C\u0438\u0442\u0435 \u0435\u0451 \u0432\u0440\u0443\u0447\u043D\u0443\u044E.");
    }
    createProjectBtn.click();
    for (let i = 0; i < 50; i++) {
      await sleep(500);
      if (isOnFlowProjectPage())
        break;
    }
    if (!isOnFlowProjectPage()) {
      throw new Error("\u041D\u0435 \u0443\u0434\u0430\u043B\u043E\u0441\u044C \u043F\u0435\u0440\u0435\u0439\u0442\u0438 \u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0443 \u043F\u0440\u043E\u0435\u043A\u0442\u0430. \u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u043F\u0440\u043E\u0435\u043A\u0442\xBB \u0432\u0440\u0443\u0447\u043D\u0443\u044E \u0438 \u043F\u043E\u0432\u0442\u043E\u0440\u0438\u0442\u0435.");
    }
    await sleep(2500);
  }
  async function uploadImageForFilmMode(imageUrl) {
    console.log("[GenFlow] Banana: Uploading image for Film mode...");
    const uploadButtons = document.querySelectorAll("button");
    let uploadBtn = null;
    for (const btn of uploadButtons) {
      const text = (btn.textContent || "").trim().toLowerCase();
      const hasAddIcon = btn.querySelector("i")?.textContent?.includes("add");
      if ((text === "add" || text === "+" || hasAddIcon) && isVisible(btn)) {
        uploadBtn = btn;
        break;
      }
    }
    if (!uploadBtn) {
      uploadBtn = document.querySelector("button.sc-d02e9a37-1");
    }
    if (uploadBtn && isVisible(uploadBtn)) {
      console.log("[GenFlow] Banana: Clicking upload button...");
      uploadBtn.click();
      await sleep(800);
    }
    const fileInput = document.querySelector('input[type="file"][accept*=".png"], input[type="file"]');
    if (!fileInput) {
      console.log("[GenFlow] Banana: No file input found for image upload");
      return;
    }
    try {
      console.log("[GenFlow] Banana: Fetching image...");
      const response = await fetch(imageUrl);
      const blob = await response.blob();
      const file = new File([blob], `film_input_${Date.now()}.png`, { type: "image/png" });
      const dataTransfer = new DataTransfer();
      dataTransfer.items.add(file);
      fileInput.files = dataTransfer.files;
      fileInput.dispatchEvent(new Event("change", { bubbles: true }));
      fileInput.dispatchEvent(new Event("input", { bubbles: true }));
      console.log("[GenFlow] Banana: Image uploaded successfully");
      await sleep(2e3);
    } catch (error) {
      console.error("[GenFlow] Banana: Image upload error:", error);
    }
  }
  async function injectPrompt(payload) {
    const { prompt, settings, slotId } = payload;
    currentPromptId = prompt.id;
    try {
      console.log(`[GenFlow] Banana: Starting injection for prompt #${prompt.number}`);
      console.log(`[GenFlow] Banana: Has input image: ${prompt.imageUrl ? "yes" : "no"}`);
      if (!isFlowHost()) {
        throw new Error("Banana content script should run on labs.google/fx");
      }
      await ensureFlowProjectPage();
      if (!isOnFlowProjectPage()) {
        throw new Error("\u041D\u0443\u0436\u043D\u0430 \u0441\u0442\u0440\u0430\u043D\u0438\u0446\u0430 \u043F\u0440\u043E\u0435\u043A\u0442\u0430 Flow. \u041D\u0430\u0436\u043C\u0438\u0442\u0435 \xAB\u0421\u043E\u0437\u0434\u0430\u0442\u044C \u043F\u0440\u043E\u0435\u043A\u0442\xBB \u0438 \u043F\u043E\u0432\u0442\u043E\u0440\u0438\u0442\u0435.");
      }
      await sleep(1500);
      await selectImageMode();
      await sleep(800);
      if (prompt.imageUrl) {
        console.log("[GenFlow] Banana: Film mode - uploading input image...");
        await uploadImageForFilmMode(prompt.imageUrl);
      }
      await waitForElement("textarea", 15e3);
      await sleep(500);
      const textarea = findFlowPromptInput();
      if (!textarea) {
        throw new Error("Could not find Flow prompt textarea");
      }
      textarea.focus();
      textarea.value = "";
      await sleep(100);
      textarea.value = prompt.text;
      textarea.dispatchEvent(new Event("input", { bubbles: true }));
      textarea.dispatchEvent(new Event("change", { bubbles: true }));
      console.log(`[GenFlow] Banana: Prompt entered: "${prompt.text.slice(0, 50)}..."`);
      await sleep(600);
      closeFlowDialogIfOpen();
      await sleep(400);
      let createBtn = findFlowCreateButton();
      for (let i = 0; i < 10; i++) {
        createBtn = findFlowCreateButton();
        if (createBtn && !createBtn.disabled)
          break;
        await sleep(300);
      }
      if (!createBtn || createBtn.disabled) {
        throw new Error("\u041A\u043D\u043E\u043F\u043A\u0430 \xAB\u0421\u043E\u0437\u0434\u0430\u0442\u044C\xBB \u043D\u0435\u0434\u043E\u0441\u0442\u0443\u043F\u043D\u0430");
      }
      console.log("[GenFlow] Banana: Clicking Create button...");
      createBtn.click();
      console.log(`[GenFlow] Banana (Flow): Started generation for prompt #${prompt.number}`);
      startCompletionMonitor(prompt, slotId);
    } catch (error) {
      console.error("[GenFlow] Banana (Flow) injection failed:", error);
      chrome.runtime.sendMessage({
        type: "GENERATION_FAILED",
        payload: {
          promptId: prompt.id,
          error: error instanceof Error ? error.message : "Unknown error"
        }
      });
    }
  }
  function startCompletionMonitor(prompt, _slotId) {
    if (observer)
      observer.disconnect();
    const existingImageSrcs = /* @__PURE__ */ new Set();
    document.querySelectorAll('img[src*="http"]').forEach((img) => {
      existingImageSrcs.add(img.src);
    });
    console.log(`[GenFlow] Banana: Snapshotted ${existingImageSrcs.size} existing images`);
    let resolved = false;
    let checkInterval = null;
    const completeGeneration = (resultUrl) => {
      if (resolved)
        return;
      resolved = true;
      if (observer) {
        observer.disconnect();
        observer = null;
      }
      if (checkInterval) {
        clearInterval(checkInterval);
        checkInterval = null;
      }
      console.log(`[GenFlow] Banana: Generation complete for prompt #${prompt.number}`);
      chrome.runtime.sendMessage({
        type: "GENERATION_COMPLETE",
        payload: { promptId: prompt.id, resultUrl }
      });
    };
    const failGeneration = (error) => {
      if (resolved)
        return;
      resolved = true;
      if (observer) {
        observer.disconnect();
        observer = null;
      }
      if (checkInterval) {
        clearInterval(checkInterval);
        checkInterval = null;
      }
      chrome.runtime.sendMessage({
        type: "GENERATION_FAILED",
        payload: { promptId: prompt.id, error }
      });
    };
    const checkForNewImage = () => {
      if (currentPromptId !== prompt.id)
        return null;
      const dlBtns = document.querySelectorAll('a[download], button[aria-label*="download" i], button[aria-label*="\u0441\u043A\u0430\u0447\u0430\u0442\u044C" i]');
      for (const btn of dlBtns) {
        if (isVisible(btn)) {
          const href = btn.getAttribute("href");
          if (href && href.startsWith("http"))
            return href;
        }
      }
      const imgs = document.querySelectorAll('img[src*="googleusercontent"], img[src*="storage.googleapis"], img[src*="lh3.google"]');
      for (const img of imgs) {
        const src = img.src;
        if (!src || existingImageSrcs.has(src))
          continue;
        if (!isVisible(img))
          continue;
        const rect = img.getBoundingClientRect();
        if (rect.width > 150 && rect.height > 100) {
          return src;
        }
      }
      const allImgs = document.querySelectorAll('img[src*="http"]');
      for (const img of allImgs) {
        const src = img.src;
        if (!src || existingImageSrcs.has(src))
          continue;
        if (!isVisible(img))
          continue;
        const w = img.naturalWidth || img.getBoundingClientRect().width;
        const h = img.naturalHeight || img.getBoundingClientRect().height;
        if (w > 300 && h > 200) {
          return src;
        }
      }
      return null;
    };
    observer = new MutationObserver(() => {
      const result = checkForNewImage();
      if (result)
        completeGeneration(result);
    });
    observer.observe(document.body, { childList: true, subtree: true, attributes: true, attributeFilter: ["src"] });
    checkInterval = setInterval(() => {
      if (resolved || currentPromptId !== prompt.id) {
        if (checkInterval)
          clearInterval(checkInterval);
        return;
      }
      const result = checkForNewImage();
      if (result)
        completeGeneration(result);
    }, 2e3);
    setTimeout(() => {
      if (!resolved && currentPromptId === prompt.id) {
        failGeneration("Generation timed out (3 min)");
      }
    }, 3 * 60 * 1e3);
  }
  console.log("[GenFlow] Banana (Flow) content script loaded");
})();
